package com.androidbook.filesoc;

import java.io.FileOutputStream;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class FileStreamOfConsciousnessActivity extends Activity {

	public static final String LOG_FILENAME = "Chat_Log.txt";
	private Handler mHandler = new Handler();

	/** Wywoływana podczas pierwszego tworzenia aktywności. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.chat);

		// Obsługa przycisku Wyślij.
		final Button sendButton = (Button) findViewById(R.id.ButtonSend);
		sendButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

			logChatMessage();

			final EditText chatText = (EditText) findViewById(R.id.EditTextChat);
			chatText.setText(null);
		
			}
		});

		// Obsługa przycisku Wyświetl zawartość plikuk.
		final Button gotoLog = (Button) findViewById(R.id.ButtonSeeLog);
		gotoLog.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				// Przejście do innej aktywności, która wyświetli zawartość pliku.
				Intent intent = new Intent(FileStreamOfConsciousnessActivity.this,
						ViewLogActivity.class);
				startActivity(intent);
			}
		});
	}

	
	
	private void logChatMessage() {
		
		new Thread(){
			public void run(){
				
				final EditText chatText = (EditText) findViewById(R.id.EditTextChat);
				String strChat = chatText.getText().toString();

				if (strChat.length() > 0) {
					
					strChat = strChat+"\n\n";

					try {
						// Otwieramy plik.
						FileOutputStream fIO = openFileOutput(LOG_FILENAME, MODE_APPEND);
						// Zapis pogawędki do pliku.
						fIO.write(strChat.getBytes());
						// Zamknięcie pliku.
						fIO.close();
						
						// Przekazanie UI informacji o wykonaniu zadania.
						mHandler.post(new Runnable() {
							public void run() {
								Toast.makeText(FileStreamOfConsciousnessActivity.this,
										"Wiadomość została zarejestrowana.",
										Toast.LENGTH_SHORT).show();
							}
						});
						
					} catch (Exception e) {
						// Nie udało się dodać wiadomości do pliku. Obsługa błędu.
					}
				}
			}
		}.start();
	}
}